const tokenEl = document.getElementById("token");
const fileEl = document.getElementById("file");
const titleEl = document.getElementById("title");
const tagsEl = document.getElementById("tags");
const addBtn = document.getElementById("addBtn");
const tbody = document.getElementById("tbody");

function token() { return (tokenEl.value || "").trim(); }

async function api(action, opts = {}) {
  const headers = new Headers(opts.headers || {});
  if (token()) headers.set("X-Admin-Token", token());
  return fetch(`api.php?action=${action}`, { ...opts, headers });
}

function renderRows(photos) {
  tbody.innerHTML = "";
  for (const p of photos) {
    const tr = document.createElement("tr");

    const tdImg = document.createElement("td");
    const img = document.createElement("img");
    img.src = `uploads/${p.filename}`;
    img.alt = p.title;
    img.style.width = "90px";
    img.style.height = "60px";
    img.style.objectFit = "cover";
    img.style.borderRadius = "10px";
    img.style.border = "1px solid rgba(255,255,255,0.08)";
    tdImg.appendChild(img);

    const tdTitle = document.createElement("td");
    const titleInput = document.createElement("input");
    titleInput.value = p.title;
    tdTitle.appendChild(titleInput);

    const tdTags = document.createElement("td");
    const tagsInput = document.createElement("input");
    tagsInput.value = (p.tags || []).join(", ");
    tdTags.appendChild(tagsInput);

    const tdActions = document.createElement("td");
    const saveBtn = document.createElement("button");
    saveBtn.className = "btn";
    saveBtn.type = "button";
    saveBtn.textContent = "Uložit";

    const delBtn = document.createElement("button");
    delBtn.className = "btn secondary";
    delBtn.type = "button";
    delBtn.textContent = "Smazat";

    saveBtn.addEventListener("click", async () => {
      const fd = new FormData();
      fd.append("id", p.id);
      fd.append("title", titleInput.value.trim() || "Bez názvu");
      fd.append("tags", tagsInput.value);

      const res = await api("admin_update", { method: "POST", body: fd });
      if (!res.ok) return alert("Uložení selhalo (token?)");
      await refresh();
    });

    delBtn.addEventListener("click", async () => {
      if (!confirm("Opravdu smazat?")) return;
      const fd = new FormData();
      fd.append("id", p.id);

      const res = await api("admin_delete", { method: "POST", body: fd });
      if (!res.ok) return alert("Smazání selhalo (token?)");
      await refresh();
    });

    tdActions.appendChild(saveBtn);
    tdActions.appendChild(delBtn);

    tr.appendChild(tdImg);
    tr.appendChild(tdTitle);
    tr.appendChild(tdTags);
    tr.appendChild(tdActions);

    tbody.appendChild(tr);
  }
}

async function refresh() {
  const res = await api("admin_list");
  const data = await res.json();
  renderRows(data.photos || []);
}

addBtn.addEventListener("click", async () => {
  const file = fileEl.files?.[0];
  if (!file) return alert("Vyber soubor.");

  const fd = new FormData();
  fd.append("file", file);
  fd.append("title", titleEl.value.trim() || "Bez názvu");
  fd.append("tags", tagsEl.value.trim());

  const res = await api("admin_add", { method: "POST", body: fd });
  if (!res.ok) return alert("Upload selhal (token?)");

  fileEl.value = "";
  titleEl.value = "";
  tagsEl.value = "";
  await refresh();
});

refresh();
