<?php
declare(strict_types=1);
require_once __DIR__ . "/db.php";

header("Content-Type: application/json; charset=utf-8");

$pdo = db();
$action = $_GET["action"] ?? "";

function json_out($arr, int $code = 200) {
  http_response_code($code);
  echo json_encode($arr, JSON_UNESCAPED_UNICODE);
  exit;
}

if ($action === "tags") {
  $tags = $pdo->query("SELECT name FROM tags ORDER BY name ASC")->fetchAll(PDO::FETCH_COLUMN);
  json_out(["tags" => $tags]);
}

if ($action === "photos") {
  $tagsParam = trim((string)($_GET["tags"] ?? ""));
  $tags = array_values(array_filter(array_map("trim", explode(",", $tagsParam))));

  if (!$tags) {
    $rows = $pdo->query("
      SELECT p.id, p.title, p.filename, p.created_at,
             GROUP_CONCAT(t.name, ',') AS tags
      FROM photos p
      LEFT JOIN photo_tags pt ON pt.photo_id = p.id
      LEFT JOIN tags t ON t.id = pt.tag_id
      GROUP BY p.id
      ORDER BY p.created_at DESC
    ")->fetchAll(PDO::FETCH_ASSOC);

    $photos = array_map(function($r) {
      $r['tags'] = $r['tags'] ? array_values(array_filter(explode(',', $r['tags']))) : [];
      return $r;
    }, $rows);

    json_out(["photos" => $photos]);
  }

  // AND filtr: fotka musí mít všechny vybrané tagy
  $norm = [];
  foreach ($tags as $t) {
    $n = norm_tag($t);
    if ($n) $norm[] = $n;
  }
  if (!$norm) json_out(["photos" => []]);

  $placeholders = implode(",", array_fill(0, count($norm), "?"));
  $stmt = $pdo->prepare("
    SELECT p.id, p.title, p.filename, p.created_at
    FROM photos p
    JOIN photo_tags pt ON pt.photo_id = p.id
    JOIN tags t ON t.id = pt.tag_id
    WHERE t.name IN ($placeholders)
    GROUP BY p.id
    HAVING COUNT(DISTINCT t.name) = ?
    ORDER BY p.created_at DESC
  ");
  $params = array_merge($norm, [count($norm)]);
  $stmt->execute($params);
  $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

  $tagStmt = $pdo->prepare("
    SELECT t.name
    FROM tags t
    JOIN photo_tags pt ON pt.tag_id = t.id
    WHERE pt.photo_id = ?
    ORDER BY t.name ASC
  ");

  $photos = [];
  foreach ($rows as $p) {
    $tagStmt->execute([$p["id"]]);
    $p["tags"] = $tagStmt->fetchAll(PDO::FETCH_COLUMN);
    $photos[] = $p;
  }

  json_out(["photos" => $photos]);
}

if ($action === "admin_list") {
  $rows = $pdo->query("
    SELECT p.id, p.title, p.filename, p.created_at,
           GROUP_CONCAT(t.name, ',') AS tags
    FROM photos p
    LEFT JOIN photo_tags pt ON pt.photo_id = p.id
    LEFT JOIN tags t ON t.id = pt.tag_id
    GROUP BY p.id
    ORDER BY p.created_at DESC
  ")->fetchAll(PDO::FETCH_ASSOC);

  $photos = array_map(function($r) {
    $r['tags'] = $r['tags'] ? array_values(array_filter(explode(',', $r['tags']))) : [];
    return $r;
  }, $rows);

  json_out(["photos" => $photos]);
}

if ($action === "admin_add") {
  if (!isset($_FILES["file"])) json_out(["error" => "Missing file"], 400);

  $title = trim((string)($_POST["title"] ?? "")) ?: "Bez názvu";
  $tags = array_values(array_filter(array_map("trim", explode(",", (string)($_POST["tags"] ?? "")))));

  $uploadsDir = __DIR__ . "/uploads";
  if (!is_dir($uploadsDir)) mkdir($uploadsDir, 0775, true);

  $tmp = $_FILES["file"]["tmp_name"];
  $orig = (string)$_FILES["file"]["name"];
  $ext = strtolower(pathinfo($orig, PATHINFO_EXTENSION));
  $allowed = ["jpg","jpeg","png","webp","gif"];
  if (!in_array($ext, $allowed, true)) $ext = "jpg";

  $filename = time() . "-" . bin2hex(random_bytes(6)) . "." . $ext;
  $dest = $uploadsDir . "/" . $filename;

  if (!move_uploaded_file($tmp, $dest)) json_out(["error" => "Upload failed"], 500);

  $pdo->prepare("INSERT INTO photos (title, filename) VALUES (?, ?)")->execute([$title, $filename]);
  $photoId = (int)$pdo->lastInsertId();

  $insertTag = $pdo->prepare("INSERT OR IGNORE INTO tags (name) VALUES (?)");
  $getTagId  = $pdo->prepare("SELECT id FROM tags WHERE name = ?");
  $insRel    = $pdo->prepare("INSERT OR IGNORE INTO photo_tags (photo_id, tag_id) VALUES (?, ?)");

  foreach ($tags as $t) {
    $n = norm_tag($t);
    if (!$n) continue;
    $insertTag->execute([$n]);
    $getTagId->execute([$n]);
    $tagId = (int)$getTagId->fetchColumn();
    if ($tagId) $insRel->execute([$photoId, $tagId]);
  }

  json_out(["id" => $photoId]);
}

if ($action === "admin_update") {
  $id = (int)($_POST["id"] ?? 0);
  $title = trim((string)($_POST["title"] ?? "")) ?: "Bez názvu";
  $tagsRaw = $_POST["tags"] ?? "";
  $tags = is_string($tagsRaw)
    ? array_values(array_filter(array_map("trim", explode(",", $tagsRaw))))
    : (is_array($tagsRaw) ? $tagsRaw : []);

  $exists = $pdo->prepare("SELECT id FROM photos WHERE id = ?");
  $exists->execute([$id]);
  if (!$exists->fetchColumn()) json_out(["error" => "Not found"], 404);

  $pdo->prepare("UPDATE photos SET title = ? WHERE id = ?")->execute([$title, $id]);
  $pdo->prepare("DELETE FROM photo_tags WHERE photo_id = ?")->execute([$id]);

  $insertTag = $pdo->prepare("INSERT OR IGNORE INTO tags (name) VALUES (?)");
  $getTagId  = $pdo->prepare("SELECT id FROM tags WHERE name = ?");
  $insRel    = $pdo->prepare("INSERT OR IGNORE INTO photo_tags (photo_id, tag_id) VALUES (?, ?)");

  foreach ($tags as $t) {
    $n = norm_tag((string)$t);
    if (!$n) continue;
    $insertTag->execute([$n]);
    $getTagId->execute([$n]);
    $tagId = (int)$getTagId->fetchColumn();
    if ($tagId) $insRel->execute([$id, $tagId]);
  }

  json_out(["ok" => true]);
}

if ($action === "admin_delete") {
  $id = (int)($_POST["id"] ?? 0);
  $stmt = $pdo->prepare("SELECT filename FROM photos WHERE id = ?");
  $stmt->execute([$id]);
  $filename = $stmt->fetchColumn();
  if (!$filename) json_out(["error" => "Not found"], 404);

  $full = __DIR__ . "/uploads/" . $filename;
  if (is_file($full)) @unlink($full);

  $pdo->prepare("DELETE FROM photos WHERE id = ?")->execute([$id]);
  json_out(["ok" => true]);
}

json_out(["error" => "Unknown action"], 400);
