<?php
declare(strict_types=1);

function db(): PDO {
  $dataDir = __DIR__ . "/data";
  if (!is_dir($dataDir)) mkdir($dataDir, 0775, true);

  $pdo = new PDO("sqlite:" . $dataDir . "/galerie.sqlite");
  $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
  $pdo->exec("PRAGMA foreign_keys = ON;");

  $pdo->exec("
    CREATE TABLE IF NOT EXISTS photos (
      id INTEGER PRIMARY KEY AUTOINCREMENT,
      title TEXT NOT NULL,
      filename TEXT NOT NULL,
      created_at TEXT NOT NULL DEFAULT (datetime('now'))
    );

    CREATE TABLE IF NOT EXISTS tags (
      id INTEGER PRIMARY KEY AUTOINCREMENT,
      name TEXT NOT NULL UNIQUE
    );

    CREATE TABLE IF NOT EXISTS photo_tags (
      photo_id INTEGER NOT NULL,
      tag_id INTEGER NOT NULL,
      PRIMARY KEY (photo_id, tag_id),
      FOREIGN KEY (photo_id) REFERENCES photos(id) ON DELETE CASCADE,
      FOREIGN KEY (tag_id) REFERENCES tags(id) ON DELETE CASCADE
    );
  ");

  return $pdo;
}

function norm_tag(string $t): string {
  $t = trim(mb_strtolower($t));
  $t = preg_replace('/\s+/u', '-', $t);
  $t = preg_replace('/[^a-z0-9\-\_]+/u', '', $t);
  return $t ?? "";
}
