import { defineConfig } from 'vite'
import react from '@vitejs/plugin-react'

// https://vite.dev/config/
export default defineConfig(({ command }) => {
  const config = {
    plugins: [react()],
    // Use different base paths for dev and production:
    // - dev: root ('/') so Vite dev server works as usual
    // - build: hosted in subdirectory /galaxy/galaxy-portfolio-main/
    base: command === 'build' ? '/galaxy/galaxy-portfolio-main/' : '/',
  }

  // Development-only settings
  // config.server = {
  //   port: 5173,
  //   strictPort: false,
  //   host: '0.0.0.0',
  //   allowedHosts: [
  //     'localhost',
  //     '127.0.0.1',
  //     '.loca.lt',
  //   ],
  // }

  return config
})
