# 📚 Attribution & Used Sources

This project would not be possible without the amazing work of artists, developers, and open-source communities. Below is a detailed list of all third-party assets, models, textures, icons, and references used throughout the portfolio.

---

## 3D Models

- **Galaxy:**  
  ["Space" by artokun](https://sketchfab.com/3d-models/need-some-space-d6521362b37b48e3a82bce4911409303) ([CC BY 4.0](https://creativecommons.org/licenses/by/4.0/))  
  [Three.js adaptation gist](https://gist.github.com/artokun/fb7f0c68a01ba5d9813abb3ccce254c4)  

- **Solar System Planets:**  
  [Planet Pixel Emporium](https://planetpixelemporium.com/sun.html)  
  (Compressed and resized)

- **Continent/City/District Satellite Image:**  
  [Google Maps](https://maps.google.com)  
  (Compressed and resized)

- **Monitor:**  
  [Desktop Monitor Low Poly](https://sketchfab.com/3d-models/desktop-monitor-low-poly-a30bb55b7e774b1fa696edbee9588835)  
  (Manually compressed in Blender and converted to jsx (tsx) with gltfjsx)

- **Phone:**  
  [Smartphone](https://sketchfab.com/3d-models/smartphone-380280333c9f4fb8a21a53d18f6789e6)  
  (Manually compressed in Blender and converted to jsx (tsx) with gltfjsx)

- **Gaming Setup:**  
  [Gaming Setup V2 Low Poly](https://sketchfab.com/3d-models/gaming-setup-v2-low-poly-c4aafe2ed67841b9b52e80e8e469dbb8)  
  (Manually compressed in Blender)

- **Sofa:**  
  [Sofa](https://sketchfab.com/3d-models/sofa-c5150557f5574ae3b8c176b6ea1e7334#download)  
  (Manually compressed in Blender)

- **PC:**  
  [PC Low Poly](https://sketchfab.com/3d-models/pc-low-poly-fe6b3b45c74d44aaacb569cbc368483e#download)  
  (Manually compressed in Blender)

- **Bike:**  
  [KTM Dirt Bike](https://sketchfab.com/3d-models/ktm-dirt-bike-e31415580d7a4a0d95ebd53895566b8f)  
  (Manually compressed in Blender)

---

## Icons

- [Flaticon](https://www.flaticon.com/)  
  - [Black Hole](https://www.flaticon.com/free-icon/black-hole_4625232)
  - [Space](https://www.flaticon.com/free-icon/space_547408)
  - [Galaxy](https://www.flaticon.com/free-icon/galaxy_1734167)
  - [Earth](https://www.flaticon.com/free-icon/earth_3924428)
  - [Earth Alt](https://www.flaticon.com/free-icon/earth_9985721)
  - [Europe](https://www.flaticon.com/free-icon/europe_6195392)
  - [City](https://www.flaticon.com/free-icon/city_220163)
  - [House/District](https://www.flaticon.com/free-icon/house_2641242)
  - [PC/Room](https://www.flaticon.com/free-icon/pc_3281395)
  - [Astronaut](https://www.flaticon.com/free-icon/astronaut_6989356)
  - [Superhero](https://www.flaticon.com/free-icon/superhero_1538408)
  - [Human](https://www.flaticon.com/free-icon/man_1057335?term=human+full&page=1&position=1&origin=search&related_id=1057335)
- [Font Awesome](https://fontawesome.com/)

---

## Tools & Tutorials

- [gltfjsx](https://github.com/pmndrs/gltfjsx) — GLTF to JSX conversion
- [Three.js Editor](https://threejs.org/editor/) — Model tweaks and exports
- [Blender](https://www.blender.org/) — 3D modeling and optimization
