<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>techinz.dev (Vladyslav Shtatskyi) - Galaxy portfolio | Full Stack Developer</title>
    <meta name="description"
        content="Portfolio of Vladyslav Shtatskyi (techinz), Full-Stack Developer with expertise in Python, JavaScript, security-focused development and DevOps infrastructure">

    <!-- fonts -->
    <link rel="stylesheet" href="./assets/fonts/fontawesome/css/all.min.css">
    <link rel="stylesheet" href="./assets/css/fonts.css">

    <!-- css -->
    <link rel="stylesheet" href="./assets/css/portfolio.css">
</head>

<body>
    <!-- navigation -->
    <nav class="navbar">
        <div class="container navbar-content">
            <div class="logo">techinz.dev</div>
            <div class="nav-links">
                <a href="#about" class="nav-link">About</a>
                <a href="#skills" class="nav-link">Skills</a>
                <a href="#approach" class="nav-link">Approach</a>
                <a href="#contact" class="nav-link">Contact</a>
            </div>
        </div>
    </nav>

    <!-- galaxy intro animation -->
<section class="galaxy-intro" id="intro">
    <div class="galaxy-viewport">
        <div class="galaxy-layer layer-space">
            <div class="galaxy-stars"></div>
        </div>
        <div class="galaxy-layer layer-planet">
            <div class="galaxy-bg" style="background-image: url('./assets/img/planets/earth.jpg');"></div>
        </div>
        <div class="galaxy-layer layer-continent">
            <div class="galaxy-bg" style="background-image: url('./assets/img/continent/continent.jpg');"></div>
        </div>
        <div class="galaxy-layer layer-city">
            <div class="galaxy-bg" style="background-image: url('./assets/img/city/city.jpg');"></div>
        </div>
        <div class="galaxy-layer layer-district">
            <div class="galaxy-bg" style="background-image: url('./assets/img/district/district.jpg');"></div>
        </div>
        <div class="galaxy-overlay">
            <div class="galaxy-label galaxy-label-top">From the vastness of space</div>
            <div class="galaxy-label galaxy-label-bottom">down to the code on your screen.</div>
        </div>
        <div class="scroll-hint">
            <span class="scroll-hint-text">Scroll to enter the portfolio</span>
            <span class="scroll-hint-icon"><i class="fas fa-mouse"></i></span>
        </div>
    </div>
</section>

    <!-- hero (about me) -->
    <section class="hero" id="home">
        <div class="container hero-content">
            <div class="hero-image">
                <img src="./assets/img/pfp.jpg" alt="Vladyslav Shtatskyi">
            </div>
            <div class="hero-text">
                <h1 class="hero-name">Vladyslav Shtatskyi</h1>
                <h2 class="hero-title">Full-Stack Developer</h2>
                <p class="hero-description">
                    I build secure, scalable systems that solve real business problems. From automation to enterprise
                    applications, my code works reliably behind the scenes so you can focus on growth. I deliver
                    solutions.
                </p>
                <div class="cta-buttons">
                    <a href="#contact" class="btn btn-primary">
                        <i class="fas fa-envelope"></i> Get in Touch
                    </a>
                </div>
            </div>
        </div>
    </section>

    <!-- about -->
    <section id="about" class="section section-bg">
        <div class="container">
            <h2 class="section-title"><span>About Me</span></h2>
            <div class="about-content">
                <div class="about-text">
                    <p>
                        My journey in software development began in my early teens, turning a passion for automation
                        into a
                        professional career building enterprise solutions. I still tackle each project with the same
                        curiosity and determination.
                    </p>
                    <p>
                        As my skills evolved, I became increasingly aware of the vulnerabilities in many systems I
                        encountered.
                        This led me to specialize in cybersecurity alongside development. Today, security isn't an
                        add-on in my work -
                        it's built into everything I create. In a world of increasing digital threats, this integrated
                        approach
                        gives my clients peace of mind.
                    </p>
                    <p>
                        Working across cultures has shaped my approach to problem-solving. Being fluent in English,
                        German, Russian, and Ukrainian has opened doors to international collaborations where diverse
                        perspectives lead to more robust solutions. This multicultural background helps me build
                        products that resonate globally.
                    </p>
                </div>
                <div class="about-info">
                    <div class="info-item">
                        <span class="info-title">Location</span>
                        <span>Hannover, Germany</span>
                    </div>
                    <div class="info-item">
                        <span class="info-title">Email</span>
                        <span><a href="mailto:contact@techinz.dev"
                                style="color: inherit; text-decoration: none;">contact@techinz.dev</a></span>
                    </div>
                    <div class="info-item">
                        <span class="info-title">Status</span>
                        <span style="color: #10b981; font-weight: 600;">
                            <i class="fas fa-check-circle" style="margin-right: 5px;"></i>Available for hire
                        </span>
                    </div>
                    <div class="info-item">
                        <span class="info-title">Experience</span>
                        <span>6+ years</span>
                    </div>
                    <div class="info-item">
                        <span class="info-title">Languages</span>
                        <div class="languages-list">
                            <span class="language-tag">English</span>
                            <span class="language-tag">German</span>
                            <span class="language-tag">Russian</span>
                            <span class="language-tag">Ukrainian</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- skills -->
    <section id="skills" class="section">
        <div class="container">
            <h2 class="section-title"><span>Skills & Technologies</span></h2>
            <div class="skills-container">
                <div class="skills-grid">
                    <!-- python -->
                    <div class="skill-card python">
                        <h3 class="skill-title"><i class="fab fa-python"></i> Python</h3>
                        <div class="skill-content">
                            <div>
                                <div class="skill-subcategory">Web Frameworks</div>
                                <div class="skill-list">
                                    <span class="skill-tag">Django</span>
                                    <span class="skill-tag">Flask</span>
                                    <span class="skill-tag">FastAPI</span>
                                </div>
                            </div>

                            <div>
                                <div class="skill-subcategory">Automation</div>
                                <div class="skill-list">
                                    <span class="skill-tag">Playwright</span>
                                    <span class="skill-tag">Selenium</span>
                                    <span class="skill-tag">Puppeteer</span>
                                </div>
                            </div>

                            <div>
                                <div class="skill-subcategory">Async Programming</div>
                                <div class="skill-list">
                                    <span class="skill-tag">Asyncio</span>
                                    <span class="skill-tag">AioHTTP</span>
                                </div>
                            </div>

                            <div>
                                <div class="skill-subcategory">Concurrency & Parallelism</div>
                                <div class="skill-list">
                                    <span class="skill-tag">Threading</span>
                                    <span class="skill-tag">Multiprocessing</span>
                                </div>
                            </div>

                            <div>
                                <div class="skill-subcategory">Data & APIs</div>
                                <div class="skill-list">
                                    <span class="skill-tag">SQLAlchemy</span>
                                    <span class="skill-tag">Pandas</span>
                                    <span class="skill-tag">Requests/Httpx</span>
                                </div>
                            </div>

                            <div>
                                <div class="skill-subcategory">Bot Development</div>
                                <div class="skill-list">
                                    <span class="skill-tag">Aiogram</span>
                                    <span class="skill-tag">Telethon</span>
                                    <span class="skill-tag">Pyrogram</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- frontend -->
                    <div class="skill-card html">
                        <h3 class="skill-title"><i class="fab fa-html5"></i> Frontend</h3>
                        <div class="skill-content">
                            <div>
                                <div class="skill-subcategory">Core Technologies</div>
                                <div class="skill-list">
                                    <span class="skill-tag">HTML</span>
                                    <span class="skill-tag">CSS</span>
                                    <span class="skill-tag">JavaScript</span>
                                </div>
                            </div>

                            <div>
                                <div class="skill-subcategory">UI/UX</div>
                                <div class="skill-list">
                                    <span class="skill-tag">Responsive Design</span>
                                    <span class="skill-tag">Animations</span>
                                </div>
                            </div>

                            <div>
                                <div class="skill-subcategory">Layout</div>
                                <div class="skill-list">
                                    <span class="skill-tag">CSS Grid</span>
                                    <span class="skill-tag">Flexbox</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- js -->
                    <div class="skill-card node">
                        <h3 class="skill-title"><i class="fab fa-node-js"></i> JavaScript</h3>
                        <div class="skill-content">
                            <div>
                                <div class="skill-subcategory">Frontend Libraries</div>
                                <div class="skill-list">
                                    <span class="skill-tag">React</span>
                                    <span class="skill-tag">Three.js</span>
                                    <span class="skill-tag">R3F</span>
                                </div>
                            </div>

                            <div>
                                <div class="skill-subcategory">Backend Technologies</div>
                                <div class="skill-list">
                                    <span class="skill-tag">Node.js</span>
                                    <span class="skill-tag">GraphQL</span>
                                </div>
                            </div>

                            <div>
                                <div class="skill-subcategory">Tools</div>
                                <div class="skill-list">
                                    <span class="skill-tag">NPM</span>
                                    <span class="skill-tag">Webpack</span>
                                    <span class="skill-tag">Vite</span>
                                </div>
                            </div>

                            <div>
                                <div class="skill-subcategory">Real-time</div>
                                <div class="skill-list">
                                    <span class="skill-tag">WebSockets</span>
                                    <span class="skill-tag">Socket.io</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- devops -->
                    <div class="skill-card linux">
                        <h3 class="skill-title"><i class="fab fa-linux"></i> DevOps</h3>
                        <div class="skill-content">
                            <div>
                                <div class="skill-subcategory">Containers</div>
                                <div class="skill-list">
                                    <span class="skill-tag">Docker</span>
                                    <span class="skill-tag">Kubernetes</span>
                                </div>
                            </div>

                            <div>
                                <div class="skill-subcategory">Databases</div>
                                <div class="skill-list">
                                    <span class="skill-tag">PostgreSQL</span>
                                    <span class="skill-tag">MySQL</span>
                                    <span class="skill-tag">Redis</span>
                                </div>
                            </div>

                            <div>
                                <div class="skill-subcategory">Server Admin</div>
                                <div class="skill-list">
                                    <span class="skill-tag">Bash</span>
                                    <span class="skill-tag">Nginx</span>
                                    <span class="skill-tag">Apache</span>
                                    <span class="skill-tag">systemd</span>
                                </div>
                            </div>

                            <div>
                                <div class="skill-subcategory">Tools</div>
                                <div class="skill-list">
                                    <span class="skill-tag">CI/CD</span>
                                    <span class="skill-tag">Cron</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- my approach -->
    <section class="section section-bg" id="approach">
        <div class="container">
            <h2 class="section-title"><span>My Approach</span></h2>
            <div class="approach-container">
                <div class="approach-item">
                    <div class="approach-icon">
                        <i class="fas fa-shield-alt"></i>
                    </div>
                    <h3>Security First</h3>
                    <p>Security isn't added later - I build it in from the start. Every line of code is written with
                        protection in mind.</p>
                </div>
                <div class="approach-item">
                    <div class="approach-icon">
                        <i class="fas fa-handshake"></i>
                    </div>
                    <h3>Results Guarantee</h3>
                    <p>I deliver on promises. My solutions are built to perform under real-world conditions, not just in
                        demos.</p>
                </div>
                <div class="approach-item">
                    <div class="approach-icon">
                        <i class="fas fa-comments"></i>
                    </div>
                    <h3>Clear Communication</h3>
                    <p>Technical jargon stays in code comments. With clients, I speak human, maintaining transparency
                        through every project phase in whichever language fits best.</p>
                </div>
                <div class="approach-item">
                    <div class="approach-icon">
                        <i class="fas fa-rocket"></i>
                    </div>
                    <h3>Future-Proof Solutions</h3>
                    <p>I build with tomorrow in mind. My solutions use scalable architectures and maintainable code that
                        adapt to changing requirements and grow with your business.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- free task (is it a good idea tho?) -->
    <section class="section">
        <div class="container">
            <div class="free-task-container">
                <div class="free-task-icon">
                    <i class="fas fa-clipboard-check"></i>
                </div>
                <h3 class="free-task-title">Try Before You Hire</h3>
                <p class="free-task-description">
                    Still deciding? Let's start with a <span>free test task</span>.
                    It's the best way to see my skills in action on your actual needs -
                    no commitment required.
                </p>
                <a href="#contact" class="btn btn-primary free-task-btn">
                    <i class="fas fa-paper-plane"></i> Request Test Task
                </a>
            </div>
        </div>
    </section>

    <!-- contact -->
    <section id="contact" class="section">
        <div class="container">
            <h2 class="section-title"><span>Get In Touch</span></h2>
            <div class="contact-container">
                <div class="contact-info">
                    <div class="contact-item">
                        <div class="contact-icon">
                            <i class="fas fa-envelope"></i>
                        </div>
                        <div class="contact-text">
                            <h4>Email</h4>
                            <p class="contact-value">
                                <a href="mailto:contact@techinz.dev"
                                    style="color: inherit; text-decoration: none;">contact@techinz.dev</a>
                            </p>
                        </div>
                    </div>

                    <div class="contact-item">
                        <div class="contact-icon">
                            <i class="fas fa-map-marker-alt"></i>
                        </div>
                        <div class="contact-text">
                            <h4>Location</h4>
                            <p class="contact-value">Hannover, Germany</p>
                        </div>
                    </div>

                    <div class="contact-item available">
                        <div class="contact-icon">
                            <i class="fas fa-briefcase"></i>
                        </div>
                        <div class="contact-text">
                            <h4>Status</h4>
                            <p class="contact-value">
                                <i class="fas fa-check-circle"></i> Available for hire
                            </p>
                        </div>
                    </div>
                </div>

                <div class="social-links">
                    <a href="https://github.com/techinz" target="_blank" class="social-link" aria-label="GitHub">
                        <i class="fab fa-github"></i>
                    </a>
                    <a href="https://t.me/playweb3" target="_blank" class="social-link" aria-label="Telegram">
                        <i class="fab fa-telegram"></i>
                    </a>
                    <a href="https://www.linkedin.com/in/vladyslav-shtatskyi-8752092a7/" target="_blank"
                        class="social-link" aria-label="LinkedIn">
                        <i class="fab fa-linkedin-in"></i>
                    </a>
                </div>
            </div>
        </div>
    </section>

    <!-- footer -->
    <footer class="footer">
        <div class="container">
            <p class="footer-text">© 2025 Vladyslav Shtatskyi (techinz). All Rights Reserved.</p>
            <p class="footer-text">This portfolio is <a href="https://github.com/techinz/galaxy-portfolio"
                    target="_blank" style="color: #3498db;">open-source</a>!</p>
        </div>
            <p class="footer-copy">© <?php echo date('Y'); ?> Galaxy Portfolio. All rights reserved.</p>
    </footer>

    <!-- scroll to top button -->
    <div class="scroll-top">
        <i class="fas fa-arrow-up"></i>
    </div>

    <!-- some js for navbar scroll -->
    <script>
        // navbar scroll effect
        window.addEventListener('scroll', function () {
            const navbar = document.querySelector('.navbar');
            const scrollTop = document.querySelector('.scroll-top');

            if (window.scrollY > 50) {
                navbar.style.padding = '0.7rem 0';
                navbar.style.boxShadow = '0 5px 20px rgba(0, 0, 0, 0.1)';
                scrollTop.classList.add('show');
            } else {
                navbar.style.padding = '1rem 0';
                navbar.style.boxShadow = 'none';
                scrollTop.classList.remove('show');
            }
        });

        // scroll to top
        document.querySelector('.scroll-top').addEventListener('click', function () {
            window.scrollTo({
                top: 0,
                behavior: 'smooth'
            });
        });
    </script>

    <script src="./assets/js/main.js"></script>
</body>

</html>