\
<?php
declare(strict_types=1);
require_once __DIR__ . '/../app/util.php';

function render_header(string $title, string $active): void { ?>
<!doctype html>
<html lang="cs">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title><?= h($title) ?></title>
  <link rel="stylesheet" href="/assets/style.css">
</head>
<body>
  <div class="nav">
    <div class="brand">💰 Finance (offline)</div>
    <a href="/?page=dashboard" class="<?= $active==='dashboard'?'active':'' ?>">Přehled</a>
    <a href="/?page=income" class="<?= $active==='income'?'active':'' ?>">Admin: Příjmy</a>
    <a href="/?page=expenses" class="<?= $active==='expenses'?'active':'' ?>">Admin: Výdaje</a>
    <a href="/?page=categories" class="<?= $active==='categories'?'active':'' ?>">Kategorie</a>
    <a href="/?page=loans" class="<?= $active==='loans'?'active':'' ?>">Úvěry</a>
  </div>
  <div class="container">
<?php }

function render_footer(): void { ?>
  <hr>
  <div class="small">Portable verze bez internetu • Data: <span class="pill">data/app.db</span></div>
  </div>
  <script src="/assets/app.js"></script>
</body>
</html>
<?php }
