\
(function(){
  // Small helpers for UX (no internet required)
  const qs = (s, el=document)=>el.querySelector(s);
  const qsa = (s, el=document)=>Array.from(el.querySelectorAll(s));

  // confirm deletes
  qsa('a[data-confirm]').forEach(a=>{
    a.addEventListener('click', (e)=>{
      if(!confirm(a.getAttribute('data-confirm'))) e.preventDefault();
    });
  });

  // multi-select tags preview
  const catSel = qs('#category_ids');
  const preview = qs('#category_preview');
  if(catSel && preview){
    const render = ()=>{
      const selected = qsa('option:checked', catSel).map(o=>o.textContent.trim());
      preview.textContent = selected.length ? selected.join(', ') : '—';
    };
    catSel.addEventListener('change', render);
    render();
  }
})();
