\
<?php
declare(strict_types=1);

function db_path(): string {
    $root = dirname(__DIR__);
    return $root . DIRECTORY_SEPARATOR . 'data' . DIRECTORY_SEPARATOR . 'app.db';
}

function db(): PDO {
    static $pdo = null;
    if ($pdo instanceof PDO) return $pdo;

    $dbFile = db_path();
    $dir = dirname($dbFile);
    if (!is_dir($dir)) mkdir($dir, 0777, true);

    $pdo = new PDO('sqlite:' . $dbFile, null, null, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    ]);
    $pdo->exec('PRAGMA foreign_keys = ON;');

    init_schema($pdo);
    return $pdo;
}

function init_schema(PDO $pdo): void {
    // Create tables if not exist
    $pdo->exec("
        CREATE TABLE IF NOT EXISTS categories (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            name TEXT NOT NULL UNIQUE
        );
    ");

    $pdo->exec("
        CREATE TABLE IF NOT EXISTS transactions (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            date TEXT NOT NULL, -- YYYY-MM-DD
            type TEXT NOT NULL CHECK(type IN ('income','expense')),
            source TEXT NULL,   -- salary|other (for income)
            category_id INTEGER NULL,
            amount REAL NOT NULL CHECK(amount >= 0),
            merchant TEXT NULL,
            note TEXT NULL,
            created_at TEXT NOT NULL DEFAULT (datetime('now')),
            FOREIGN KEY(category_id) REFERENCES categories(id) ON DELETE SET NULL
        );
    ");

    $pdo->exec("
        CREATE TABLE IF NOT EXISTS loans (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            name TEXT NOT NULL,
            principal_total REAL NOT NULL CHECK(principal_total >= 0),
            start_date TEXT NOT NULL,
            planned_monthly_payment REAL NULL CHECK(planned_monthly_payment >= 0),
            note TEXT NULL,
            created_at TEXT NOT NULL DEFAULT (datetime('now'))
        );
    ");

    $pdo->exec("
        CREATE TABLE IF NOT EXISTS loan_payments (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            loan_id INTEGER NOT NULL,
            date TEXT NOT NULL,
            amount REAL NOT NULL CHECK(amount >= 0),
            note TEXT NULL,
            created_at TEXT NOT NULL DEFAULT (datetime('now')),
            FOREIGN KEY(loan_id) REFERENCES loans(id) ON DELETE CASCADE
        );
    ");
}
