<?php
require __DIR__ . '/auth.php';
require_login();

// admin/save.php
// Receives JSON: { notices: [{text:"...", meta:"..."}] } and writes to ../data/notices.json
header('Content-Type: application/json; charset=utf-8');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  http_response_code(405);
  echo json_encode(['ok' => false, 'error' => 'Method not allowed']);
  exit;
}

$raw = file_get_contents('php://input');
$data = json_decode($raw, true);

if (!is_array($data) || !isset($data['notices']) || !is_array($data['notices'])) {
  http_response_code(400);
  echo json_encode(['ok' => false, 'error' => 'Invalid JSON payload']);
  exit;
}

$notices = $data['notices'];
$out = [];
$max = 20;

foreach ($notices as $n) {
  if (!is_array($n)) continue;
  $text = isset($n['text']) ? trim((string)$n['text']) : '';
  $meta = isset($n['meta']) ? trim((string)$n['meta']) : '';
  if ($text === '') continue;
  $out[] = ['text' => $text, 'meta' => $meta];
  if (count($out) >= $max) break;
}

// Atomic write
$target = dirname(__DIR__) . '/data/notices.json';
$tmp = $target . '.tmp';

$json = json_encode($out, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);

if ($json === false) {
  http_response_code(500);
  echo json_encode(['ok' => false, 'error' => 'JSON encode failed']);
  exit;
}

if (file_put_contents($tmp, $json) === false) {
  http_response_code(500);
  echo json_encode(['ok' => false, 'error' => 'Cannot write temp file. Check permissions on /data']);
  exit;
}

if (!rename($tmp, $target)) {
  @unlink($tmp);
  http_response_code(500);
  echo json_encode(['ok' => false, 'error' => 'Cannot replace notices.json. Check permissions on /data']);
  exit;
}

echo json_encode(['ok' => true]);
