<?php
require __DIR__ . '/auth.php';
header('Content-Type: text/html; charset=utf-8');

$err = '';
$next = isset($_GET['next']) ? (string)$_GET['next'] : 'index.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $user = isset($_POST['user']) ? (string)$_POST['user'] : '';
  $pass = isset($_POST['pass']) ? (string)$_POST['pass'] : '';
  $next = isset($_POST['next']) ? (string)$_POST['next'] : 'index.php';

  if (verify_credentials($user, $pass)) {
    session_regenerate_id(true);
    $_SESSION['admin_logged_in'] = true;
    header('Location: ' . $next);
    exit;
  } else {
    $err = 'Nesprávné jméno nebo heslo.';
  }
}
?>
<!doctype html>
<html lang="cs">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Přihlášení – Admin</title>
  <meta name="robots" content="noindex,nofollow" />
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Nunito:wght@400;700;900&display=swap" rel="stylesheet">
  <style>
    :root{ --bg:#E8F6FE; --ink:#1F2938; --teal:#5AA1B7; --stroke: rgba(31,41,56,.10);
      --card: rgba(255,255,255,.86); --shadow: 0 12px 30px rgba(31,41,56,.10); --radius:18px; }
    *{box-sizing:border-box}
    body{
      margin:0; font-family:"Nunito",system-ui,-apple-system,Segoe UI,Roboto,Arial,sans-serif; color:var(--ink);
      background: radial-gradient(900px 500px at 20% 35%, rgba(143,212,232,.35), transparent 60%),
                  radial-gradient(700px 420px at 80% 25%, rgba(245,216,97,.35), transparent 60%),
                  linear-gradient(180deg, var(--bg), #ffffff 70%);
      min-height:100vh; display:flex; align-items:center; justify-content:center; padding:16px;
    }
    .card{width:520px;max-width:100%;background:var(--card);border:1px solid var(--stroke);border-radius:var(--radius);box-shadow:var(--shadow);overflow:hidden;}
    .head{padding:14px 16px;background: linear-gradient(135deg, rgba(255,255,255,.90), rgba(255,255,255,.60));border-bottom:1px solid var(--stroke);display:flex;align-items:center;gap:12px;}
    .logo{height:40px;width:auto;display:block}
    .ttl{margin:0;font-weight:900;font-size:18px}
    .sub{margin:2px 0 0;opacity:.75;font-weight:800;font-size:13px}
    .inner{padding:16px}
    label{display:block;font-weight:900;font-size:12px;opacity:.80;text-transform:uppercase;letter-spacing:.35px;margin:10px 0 6px;}
    input{width:100%;padding:10px 12px;border-radius:12px;border:1px solid var(--stroke);font:inherit;background:rgba(255,255,255,.92);outline:none;}
    .btn{border:0;border-radius:999px;padding:10px 14px;font-weight:900;cursor:pointer;background: linear-gradient(135deg, var(--teal), rgba(143,212,232,.95));color:#fff;box-shadow: 0 12px 24px rgba(90,161,183,.20);display:inline-flex;gap:8px;align-items:center;}
    .row{display:flex;gap:10px;flex-wrap:wrap;margin-top:12px;align-items:center;justify-content:space-between;}
    .err{margin-top:10px;font-weight:900;color:#8a1f1f;}
    .hint{margin-top:12px;font-size:13px;opacity:.78;font-weight:800;line-height:1.35;}
    code{background:rgba(143,212,232,.18);padding:2px 6px;border-radius:6px;border:1px solid var(--stroke)}
  </style>
</head>
<body>
  <div class="card">
    <div class="head">
      <img class="logo" src="../assets/logo.png" alt="logo">
      <div style="min-width:0">
        <p class="ttl">Přihlášení do adminu</p>
        <p class="sub">Správa upozornění</p>
      </div>
    </div>
    <div class="inner">
      <form method="post" autocomplete="off">
        <input type="hidden" name="next" value="<?php echo htmlspecialchars($next, ENT_QUOTES, 'UTF-8'); ?>">
        <label for="user">Uživatel</label>
        <input id="user" name="user" required value="<?php echo htmlspecialchars(ADMIN_USER, ENT_QUOTES, 'UTF-8'); ?>">
        <label for="pass">Heslo</label>
        <input id="pass" name="pass" type="password" required>
        <div class="row">
          <button class="btn" type="submit">🔐 Přihlásit</button>
          <a href="../index.html" style="font-weight:900; color:inherit; opacity:.8; text-decoration:none;">← Zpět na web</a>
        </div>
        <?php if ($err): ?>
          <div class="err"><?php echo htmlspecialchars($err, ENT_QUOTES, 'UTF-8'); ?></div>
        <?php endif; ?>
      </form>

      <div class="hint">
        Heslo změníš v <code>admin/config.php</code>. Pro bezpečnost potom smaž <code>admin/setup.php</code>.
      </div>
    </div>
  </div>
</body>
</html>
