<?php
require __DIR__ . '/config.php';

if (session_status() !== PHP_SESSION_ACTIVE) {
  session_start();
}

function is_logged_in(): bool {
  return isset($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in'] === true;
}

function require_login(): void {
  if (!is_logged_in()) {
    $next = urlencode($_SERVER['REQUEST_URI'] ?? 'index.php');
    header('Location: login.php?next=' . $next);
    exit;
  }
}

function verify_credentials(string $user, string $pass): bool {
  $user_ok = hash_equals(ADMIN_USER, $user);
  $hash = hash('sha256', ADMIN_SALT . $pass);
  $pass_ok = hash_equals(ADMIN_PASS_HASH, $hash);
  return $user_ok && $pass_ok;
}
