<?php
// admin/setup.php
// Jednorázová pomůcka: vygeneruje hash ze zadaného hesla.
// Po nastavení doporučuji soubor smazat nebo přejmenovat.
require __DIR__ . '/config.php';

header('Content-Type: text/html; charset=utf-8');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $pass = isset($_POST['password']) ? (string)$_POST['password'] : '';
  $hash = hash('sha256', ADMIN_SALT . $pass);
  ?>
  <!doctype html><html lang="cs"><meta charset="utf-8"><title>Setup – hash</title>
  <body style="font-family:system-ui;max-width:760px;margin:40px auto;line-height:1.4">
    <h1>Vygenerovaný hash</h1>
    <p>Zkopíruj hodnotu do <code>ADMIN_PASS_HASH</code> v <code>admin/config.php</code>:</p>
    <pre style="padding:12px;border:1px solid #ccc;border-radius:8px;background:#fafafa"><?php echo htmlspecialchars($hash, ENT_QUOTES, 'UTF-8'); ?></pre>
    <p><strong>Doporučení:</strong> Soubor <code>admin/setup.php</code> potom smaž nebo přejmenuj.</p>
    <p><a href="login.php">→ Přihlášení</a></p>
  </body></html>
  <?php
  exit;
}
?>
<!doctype html>
<html lang="cs">
<meta charset="utf-8">
<title>Admin setup</title>
<body style="font-family:system-ui;max-width:760px;margin:40px auto;line-height:1.4">
  <h1>Admin setup – vygenerovat hash hesla</h1>
  <p>Salt je uložený v <code>admin/config.php</code>. Zadej nové heslo a vygeneruj hash.</p>
  <form method="post">
    <label>Nové heslo<br><input type="password" name="password" style="padding:10px;width:320px;max-width:100%"></label>
    <div style="margin-top:12px"><button style="padding:10px 14px">Vygenerovat</button></div>
  </form>
  <p style="margin-top:18px;color:#555">Po použití doporučuji setup stránku odstranit.</p>
</body>
</html>
