<?php
require __DIR__ . '/config.php';

if (session_status() !== PHP_SESSION_ACTIVE) {
    session_start();
}

function is_logged_in(): bool {
    return !empty($_SESSION['admin_logged_in']);
}

function require_login(): void {
    if (!is_logged_in()) {
        header('Location: login.php');
        exit;
    }
}

function verify_credentials(string $user, string $pass): bool {
    if ($user !== ADMIN_USER) return false;
    $hash = hash('sha256', ADMIN_SALT . $pass);
    return hash_equals(ADMIN_PASS_HASH, $hash);
}
