<?php
header('Content-Type: application/json; charset=utf-8');

$force = isset($_GET['force']) && $_GET['force'] == '1';

$cacheDir = __DIR__ . '/cache';
$cacheFile = $cacheDir . '/prices.json';
$maxAgeSeconds = 24 * 60 * 60; // 24h

$cg = [
  "BTC"   => "bitcoin",
  "DOGE"  => "dogecoin",
  "WAVES" => "waves",
  "BTCZ"  => "bitcoinz",
  "KICK"  => "kick",
  "SWEAT" => "sweat-economy",
  "EGG"   => "waves-ducks"
];

$paprikaFoneId = "fone-fone";

function now_iso() { return gmdate('c'); }

function read_cache($file) {
  if (!file_exists($file)) return null;
  $raw = @file_get_contents($file);
  if ($raw === false) return null;
  $data = json_decode($raw, true);
  return is_array($data) ? $data : null;
}

function write_cache($dir, $file, $data) {
  if (!is_dir($dir)) @mkdir($dir, 0775, true);
  $raw = json_encode($data, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
  @file_put_contents($file, $raw);
}

function cache_is_fresh($file, $maxAge) {
  if (!file_exists($file)) return false;
  $age = time() - filemtime($file);
  return $age >= 0 && $age <= $maxAge;
}

function curl_get_json($url) {
  if (!function_exists('curl_init')) return null;
  $ch = curl_init($url);
  curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_TIMEOUT => 12,
    CURLOPT_CONNECTTIMEOUT => 8,
    CURLOPT_USERAGENT => 'CryptoPortfolioCZK/2.0',
    CURLOPT_FOLLOWLOCATION => true,
  ]);
  $raw = curl_exec($ch);
  $http = curl_getinfo($ch, CURLINFO_HTTP_CODE);
  curl_close($ch);
  if ($raw === false || $http < 200 || $http >= 300) return null;
  $data = json_decode($raw, true);
  return is_array($data) ? $data : null;
}

if (!$force && cache_is_fresh($cacheFile, $maxAgeSeconds)) {
  $cached = read_cache($cacheFile);
  if ($cached && isset($cached['prices'])) {
    echo json_encode($cached, JSON_UNESCAPED_UNICODE);
    exit;
  }
}

$prices = [];

// CoinGecko (CZK)
$cgIds = implode(',', array_values($cg));
$cgUrl = 'https://api.coingecko.com/api/v3/simple/price?' . http_build_query([
  'ids' => $cgIds,
  'vs_currencies' => 'czk'
]);

$cgData = curl_get_json($cgUrl);
if (is_array($cgData)) {
  foreach ($cg as $sym => $id) {
    if (isset($cgData[$id]['czk']) && is_numeric($cgData[$id]['czk'])) {
      $prices[$sym] = (float)$cgData[$id]['czk'];
    }
  }
}

// CoinPaprika – FONE (CZK)
$paprikaUrl = 'https://api.coinpaprika.com/v1/tickers/' . rawurlencode($paprikaFoneId) . '?' . http_build_query([
  'quotes' => 'CZK'
]);

$paprikaData = curl_get_json($paprikaUrl);
if (is_array($paprikaData) && isset($paprikaData['quotes']['CZK']['price']) && is_numeric($paprikaData['quotes']['CZK']['price'])) {
  $prices['FONE'] = (float)$paprikaData['quotes']['CZK']['price'];
}

if (count($prices) === 0) {
  $cached = read_cache($cacheFile);
  if ($cached && isset($cached['prices'])) {
    echo json_encode($cached, JSON_UNESCAPED_UNICODE);
    exit;
  }
  http_response_code(502);
  echo json_encode(['error' => 'Nepodařilo se stáhnout data (CoinGecko/CoinPaprika).'], JSON_UNESCAPED_UNICODE);
  exit;
}

$out = ['lastUpdated' => now_iso(), 'prices' => $prices];
write_cache($cacheDir, $cacheFile, $out);
echo json_encode($out, JSON_UNESCAPED_UNICODE);
