<?php
$active = 'items';
$mode = $selected_collection ? 'single' : 'all';

$filter = $_GET['filter'] ?? '';
$search = trim($_GET['q'] ?? '');

$filtered = [];
foreach ($items as $it) {
  if ($selected_collection && ($it['collection_id'] ?? '') !== $selected_collection['id']) continue;
  if ($filter === 'missing_photo' && !empty($it['photo'])) continue;
  if ($filter === 'missing_value' && isset($it['est_value']) && $it['est_value'] !== '' && $it['est_value'] !== null) continue;
  if ($search !== '') {
    $hay = strtolower(($it['title'] ?? '') . ' ' . ($it['country'] ?? '') . ' ' . ($it['grade'] ?? '') . ' ' . implode(' ', (array)($it['tags'] ?? [])));
    if (strpos($hay, strtolower($search)) === false) continue;
  }
  $filtered[] = $it;
}

// sort by est_value desc
usort($filtered, function($a,$b){
  return (float)($b['est_value'] ?? 0) <=> (float)($a['est_value'] ?? 0);
});

include __DIR__ . '/../partials/header.php';
?>

<section class="section">
  <div class="section-header">
    <div>
      <h1>Položky</h1>
      <p class="muted"><?php echo $selected_collection ? 'Sbírka: <strong>'.h($selected_collection['name']).'</strong>' : 'Napříč sbírkami'; ?></p>
    </div>
    <div class="row">
      <button class="btn" data-open-modal="#modal-quick-add">Přidat položku</button>
      <a class="btn" href="?page=collections">Sbírky</a>
    </div>
  </div>

  <form class="filters" method="get">
    <input type="hidden" name="page" value="items" />
    <?php if($selected_collection): ?>
      <input type="hidden" name="collection" value="<?php echo h($selected_collection['id']); ?>" />
    <?php endif; ?>
    <input name="q" placeholder="Hledat..." value="<?php echo h($search); ?>" />
    <select name="filter">
      <option value="" <?php echo $filter===''?'selected':''; ?>>Bez filtru</option>
      <option value="missing_photo" <?php echo $filter==='missing_photo'?'selected':''; ?>>Chybí foto</option>
      <option value="missing_value" <?php echo $filter==='missing_value'?'selected':''; ?>>Chybí ocenění</option>
    </select>
    <button class="btn" type="submit">Použít</button>
    <a class="btn" href="?page=items<?php echo $selected_collection ? '&collection='.h($selected_collection['id']) : ''; ?>">Reset</a>
  </form>

  <div class="panel">
    <div class="panel-head">
      <div class="muted">Zobrazeno: <strong><?php echo count($filtered); ?></strong></div>
    </div>
    <div class="table-wrap">
      <table class="table">
        <thead>
          <tr>
            <th>Název</th>
            <th>Rok</th>
            <th>Stav</th>
            <th>Tagy</th>
            <th>Lokace</th>
            <th class="right">Odhad</th>
          </tr>
        </thead>
        <tbody>
          <?php if(!count($filtered)): ?>
            <tr><td colspan="6" class="muted">Žádné položky.</td></tr>
          <?php endif; ?>
          <?php foreach($filtered as $it): ?>
            <tr class="click" onclick="location.href='?page=item&id=<?php echo h($it['id']); ?>'">
              <td>
                <div class="cell-title"><?php echo h($it['title'] ?? ''); ?></div>
                <div class="muted small"><?php echo h(($it['collection_id'] ?? '') . ''); ?></div>
              </td>
              <td><?php echo h((string)($it['year'] ?? '—')); ?></td>
              <td><span class="badge"><?php echo h($it['grade'] ?? '—'); ?></span></td>
              <td>
                <?php foreach((array)($it['tags'] ?? []) as $t): ?>
                  <span class="tag"><?php echo h($t); ?></span>
                <?php endforeach; ?>
              </td>
              <td><?php echo h($it['location'] ?? '—'); ?></td>
              <td class="right"><?php
                $cur = 'CZK';
                if ($selected_collection) $cur = $selected_collection['currency'] ?? 'CZK';
                else {
                  $c = find_by_id($collections, $it['collection_id'] ?? '');
                  $cur = $c['currency'] ?? 'CZK';
                }
                echo money_fmt($it['est_value'] ?? null, $cur);
              ?></td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>
</section>

<!-- Quick add modal -->
<div class="modal" id="modal-quick-add" aria-hidden="true">
  <div class="modal-card">
    <div class="modal-head">
      <div>
        <div class="title">Přidat položku</div>
        <div class="muted small">Rychlý záznam (1 minuta). Detaily doplníš později.</div>
      </div>
      <button class="icon-btn" data-close-modal aria-label="Zavřít">✕</button>
    </div>

    <form method="post" action="?action=create_item" class="form">
      <div class="grid">
        <label>
          <div class="label">Sbírka</div>
          <select name="collection_id" required>
            <?php foreach($collections as $c): ?>
              <option value="<?php echo h($c['id']); ?>" <?php echo ($selected_collection && $selected_collection['id']===$c['id'])?'selected':''; ?>>
                <?php echo h($c['name']); ?>
              </option>
            <?php endforeach; ?>
          </select>
        </label>
        <label>
          <div class="label">Název</div>
          <input name="title" placeholder="např. 10 Kčs 1957" required />
        </label>
        <label>
          <div class="label">Kusů</div>
          <input type="number" name="qty" value="1" min="1" />
        </label>
        <label>
          <div class="label">Odhad (v měně sbírky)</div>
          <input type="number" name="est_value" placeholder="např. 1500" />
        </label>
        <label>
          <div class="label">Rok</div>
          <input type="number" name="year" placeholder="např. 1999" />
        </label>
        <label>
          <div class="label">Tagy (čárky)</div>
          <input name="tags" placeholder="rare, favorite" />
        </label>
      </div>
      <div class="modal-actions">
        <button class="btn" type="button" data-close-modal>Zrušit</button>
        <button class="btn primary" type="submit">Uložit</button>
      </div>
    </form>
  </div>
</div>

<?php include __DIR__ . '/../partials/footer.php'; ?>
