<?php
$active = 'items';
$mode = $selected_collection ? 'single' : 'all';

$item_id = $_GET['id'] ?? '';
$item = $item_id ? find_by_id($items, $item_id) : null;
if (!$item) {
  flash_set('Položka nenalezena.', 'error');
  redirect($selected_collection ? '?page=items&collection=' . h($selected_collection['id']) : '?page=items');
}

$coll = find_by_id($collections, $item['collection_id'] ?? '');
$selected_collection = $selected_collection ?? $coll;
$collections = $collections;
include __DIR__ . '/../partials/header.php';
?>

<section class="section">
  <div class="section-header">
    <div>
      <h1><?= h($item['title'] ?? 'Položka') ?></h1>
      <p class="muted">
        Sbírka: <a href="?page=collection&collection=<?= h($coll['id'] ?? '') ?>"><?= h($coll['name'] ?? '—') ?></a>
        • Typ: <?= h(type_label($coll['type'] ?? '')) ?>
      </p>
    </div>
    <div class="actions">
      <a class="btn" href="?page=items<?= $selected_collection ? '&collection=' . h($selected_collection['id']) : '' ?>">Zpět</a>
      <button class="btn primary" data-open-modal="#editItem">Upravit</button>
    </div>
  </div>

  <div class="grid-2">
    <div class="panel">
      <div class="panel-title">Fotka</div>
      <?php if (!empty($item['photo'])): ?>
        <img class="item-photo" src="<?= h($item['photo']) ?>" alt="photo" />
      <?php else: ?>
        <div class="empty small">
          <div class="emoji">📷</div>
          <div>
            <div class="empty-title">Chybí fotka</div>
            <div class="muted">Přidej fotku pro lepší přehled a rychlejší prodej.</div>
          </div>
        </div>
      <?php endif; ?>
    </div>

    <div class="panel">
      <div class="panel-title">Základní info</div>
      <div class="kv">
        <div class="k">Rok</div><div class="v"><?= h((string)($item['year'] ?? '—')) ?></div>
        <div class="k">Země</div><div class="v"><?= h($item['country'] ?? '—') ?></div>
        <div class="k">Množství</div><div class="v"><?= h((string)($item['qty'] ?? 1)) ?></div>
        <div class="k">Stav/Grading</div><div class="v"><?= h($item['grade'] ?? '—') ?></div>
        <div class="k">Lokace</div><div class="v"><?= h($item['location'] ?? '—') ?></div>
      </div>
      <hr class="sep" />
      <div class="panel-title">Hodnota</div>
      <div class="kv">
        <div class="k">Nákup</div><div class="v"><?= money_fmt($item['buy_price'] ?? null, $coll['currency'] ?? 'CZK') ?></div>
        <div class="k">Odhad</div><div class="v"><strong><?= money_fmt($item['est_value'] ?? null, $coll['currency'] ?? 'CZK') ?></strong></div>
        <div class="k">Aktualizováno</div><div class="v"><?= h($item['updated_at'] ?? '—') ?></div>
      </div>
      <hr class="sep" />
      <div class="panel-title">Tagy</div>
      <div class="tags">
        <?php foreach (($item['tags'] ?? []) as $t): ?>
          <span class="tag"><?= h($t) ?></span>
        <?php endforeach; ?>
        <?php if (empty($item['tags'])): ?>
          <span class="muted">—</span>
        <?php endif; ?>
      </div>
      <hr class="sep" />
      <div class="panel-title">Poznámky</div>
      <p class="muted" style="margin:0; white-space:pre-wrap"><?= h($item['notes'] ?? '') ?: '—' ?></p>
    </div>
  </div>
</section>

<!-- Edit item modal -->
<div class="modal" id="editItem" aria-hidden="true">
  <div class="modal-card">
    <div class="modal-head">
      <div>
        <div class="modal-title">Upravit položku</div>
        <div class="muted">Prototype uloží změny do JSON.</div>
      </div>
      <button class="icon-btn" data-close-modal aria-label="close">✕</button>
    </div>
    <form class="modal-body" method="post" enctype="multipart/form-data" action="?action=update_item">
      <input type="hidden" name="id" value="<?= h($item['id']) ?>" />
      <input type="hidden" name="collection_id" value="<?= h($item['collection_id']) ?>" />
      <div class="form-grid">
        <label>
          <div class="label">Název</div>
          <input name="title" value="<?= h($item['title'] ?? '') ?>" required />
        </label>
        <label>
          <div class="label">Množství</div>
          <input type="number" name="qty" value="<?= h((string)($item['qty'] ?? 1)) ?>" min="1" />
        </label>
        <label>
          <div class="label">Rok</div>
          <input type="number" name="year" value="<?= h((string)($item['year'] ?? '')) ?>" />
        </label>
        <label>
          <div class="label">Země</div>
          <input name="country" value="<?= h($item['country'] ?? '') ?>" />
        </label>
        <label>
          <div class="label">Stav/Grading</div>
          <input name="grade" value="<?= h($item['grade'] ?? '') ?>" placeholder="RAW / PSA 9 / VF..." />
        </label>
        <label>
          <div class="label">Lokace</div>
          <input name="location" value="<?= h($item['location'] ?? '') ?>" placeholder="Album 1 / Strana 3" />
        </label>
        <label>
          <div class="label">Nákupní cena</div>
          <input type="number" name="buy_price" value="<?= h((string)($item['buy_price'] ?? '')) ?>" />
        </label>
        <label>
          <div class="label">Odhad</div>
          <input type="number" name="est_value" value="<?= h((string)($item['est_value'] ?? '')) ?>" />
        </label>
        <label class="span2">
          <div class="label">Tagy (čárky)</div>
          <input name="tags" value="<?= h(implode(', ', $item['tags'] ?? [])) ?>" />
        </label>
        <label class="span2">
          <div class="label">Poznámky</div>
          <textarea name="notes" rows="3"><?= h($item['notes'] ?? '') ?></textarea>
        </label>
        <label class="span2">
          <div class="label">Nahrát / přepsat fotku</div>
          <input type="file" name="photo" accept="image/*" />
        </label>
      </div>
      <div class="modal-actions">
        <button class="btn" type="button" data-close-modal>Zrušit</button>
        <button class="btn primary" type="submit">Uložit změny</button>
      </div>
    </form>
  </div>
</div>

<?php include __DIR__ . '/../partials/footer.php'; ?>
