<?php
$active = 'collections';
$mode = 'all';
$statsByCollection = collection_stats($collections, $items);
include __DIR__ . '/../partials/header.php';
?>

<section class="section">
  <div class="section-header">
    <div>
      <h1>Sbírky</h1>
      <p class="muted">Oddělené sbírky pod jedním účtem. Každá sbírka má vlastní položky, měnu a pravidla.</p>
    </div>
    <button class="btn primary" data-open-modal="#modalNewCollection">+ Vytvořit sbírku</button>
  </div>

  <div class="grid">
    <?php foreach ($collections as $c):
      $st = $statsByCollection[$c['id']] ?? ['items'=>0,'value'=>0,'missing_photo'=>0,'missing_value'=>0,'currency'=>$c['currency'] ?? 'CZK'];
      $healthTotal = max(1, ($st['items']>0? $st['items']: 1));
      $health = 100;
      if ($st['items'] > 0) {
        $health = (int)round(100 * (1 - (($st['missing_photo'] + $st['missing_value']) / (2*max(1,$st['items'])))));
      }
    ?>
      <a class="card" href="?page=collection&collection=<?= h($c['id']) ?>">
        <div class="card-top">
          <div>
            <div class="kicker"><?= h(type_label($c['type'] ?? 'mixed')) ?></div>
            <div class="title"><?= h($c['name']) ?></div>
          </div>
          <div class="pill"><?= h($c['currency'] ?? 'CZK') ?></div>
        </div>
        <div class="stats-row">
          <div class="stat">
            <div class="stat-label">Položek</div>
            <div class="stat-value"><?= (int)$st['items'] ?></div>
          </div>
          <div class="stat">
            <div class="stat-label">Odhad</div>
            <div class="stat-value"><?= money_fmt($st['value'], $st['currency']) ?></div>
          </div>
        </div>
        <div class="meter">
          <div class="meter-bar" style="width: <?= (int)$health ?>%"></div>
        </div>
        <div class="muted small">Zdraví dat: <?= (int)$health ?>% • Bez fotky: <?= (int)$st['missing_photo'] ?> • Bez ceny: <?= (int)$st['missing_value'] ?></div>
      </a>
    <?php endforeach; ?>
  </div>
</section>

<!-- New Collection Modal -->
<div class="modal" id="modalNewCollection" aria-hidden="true">
  <div class="modal-card">
    <div class="modal-head">
      <div>
        <div class="kicker">Vytvořit sbírku</div>
        <div class="title">Nová sbírka</div>
      </div>
      <button class="icon-btn" data-close-modal aria-label="Zavřít">✕</button>
    </div>
    <form method="post" action="?action=create_collection">
      <div class="form-grid">
        <label>
          <div class="label">Název</div>
          <input name="name" required placeholder="např. TCG - Pokemon" />
        </label>
        <label>
          <div class="label">Typ</div>
          <select name="type">
            <option value="stamps">Známky</option>
            <option value="coins">Mince</option>
            <option value="banknotes">Bankovky</option>
            <option value="tcg">TCG</option>
            <option value="crypto">Krypto</option>
            <option value="mixed">Mixed</option>
          </select>
        </label>
        <label>
          <div class="label">Měna</div>
          <select name="currency">
            <option value="CZK">CZK</option>
            <option value="EUR">EUR</option>
            <option value="USD">USD</option>
          </select>
        </label>
      </div>
      <div class="modal-actions">
        <button class="btn" type="button" data-close-modal>Zrušit</button>
        <button class="btn primary" type="submit">Vytvořit</button>
      </div>
    </form>
  </div>
</div>

<?php include __DIR__ . '/../partials/footer.php'; ?>
