<?php
session_start();
require_once __DIR__ . '/functions.php';

$collections = read_json('collections.json');
$items = read_json('items.json');

$page = $_GET['page'] ?? 'dashboard';
$collection_id = $_GET['collection'] ?? null;
$selected_collection = $collection_id ? find_by_id($collections, $collection_id) : null;

// ---------- Actions (POST) ----------
$action = $_GET['action'] ?? null;

if ($action === 'create_collection' && $_SERVER['REQUEST_METHOD'] === 'POST') {
  $name = trim($_POST['name'] ?? '');
  $type = $_POST['type'] ?? 'mixed';
  $currency = $_POST['currency'] ?? 'CZK';
  if ($name === '') {
    flash_set('Zadej název sbírky.', 'error');
    redirect('index.php?page=collections');
  }
  $new = [
    'id' => uuid('c'),
    'name' => $name,
    'type' => $type,
    'currency' => $currency,
    'created_at' => now_date()
  ];
  $collections[] = $new;
  write_json('collections.json', $collections);
  flash_set('Sbírka vytvořena.');
  redirect('index.php?page=collection&collection=' . urlencode($new['id']));
}

if ($action === 'create_item' && $_SERVER['REQUEST_METHOD'] === 'POST') {
  $cid = $_POST['collection_id'] ?? '';
  $title = trim($_POST['title'] ?? '');
  $qty = max(1, (int)($_POST['qty'] ?? 1));
  $year = (int)($_POST['year'] ?? 0);
  $country = trim($_POST['country'] ?? '');
  $grade = trim($_POST['grade'] ?? '');
  $tags = array_values(array_filter(array_map('trim', explode(',', $_POST['tags'] ?? ''))));
  $location = trim($_POST['location'] ?? '');
  $buy_price = ($_POST['buy_price'] ?? '') === '' ? null : (float)$_POST['buy_price'];
  $est_value = ($_POST['est_value'] ?? '') === '' ? null : (float)$_POST['est_value'];
  $notes = trim($_POST['notes'] ?? '');

  if (!$cid || !find_by_id($collections, $cid)) {
    flash_set('Vyber sbírku.', 'error');
    redirect('index.php?page=collections');
  }
  if ($title === '') {
    flash_set('Zadej název položky.', 'error');
    redirect('index.php?page=items&collection=' . urlencode($cid));
  }

  $photo = null;
  if (!empty($_FILES['photo']['name'] ?? '')) {
    $ext = strtolower(pathinfo($_FILES['photo']['name'], PATHINFO_EXTENSION));
    $allowed = ['jpg','jpeg','png','webp'];
    if (in_array($ext, $allowed, true) && is_uploaded_file($_FILES['photo']['tmp_name'])) {
      $fname = uuid('p') . '.' . $ext;
      $dest = __DIR__ . '/uploads/' . $fname;
      move_uploaded_file($_FILES['photo']['tmp_name'], $dest);
      $photo = 'uploads/' . $fname;
    }
  }

  $item = [
    'id' => uuid('i'),
    'collection_id' => $cid,
    'title' => $title,
    'year' => $year ?: null,
    'country' => $country,
    'qty' => $qty,
    'grade' => $grade,
    'tags' => $tags,
    'location' => $location,
    'buy_price' => $buy_price,
    'est_value' => $est_value,
    'updated_at' => now_date(),
    'notes' => $notes,
    'photo' => $photo
  ];

  $items[] = $item;
  write_json('items.json', $items);
  flash_set('Položka přidána.');
  redirect('index.php?page=item&collection=' . urlencode($cid) . '&id=' . urlencode($item['id']));
}

if ($action === 'delete_item' && $_SERVER['REQUEST_METHOD'] === 'POST') {
  $cid = $_POST['collection_id'] ?? '';
  $id = $_POST['id'] ?? '';
  $items = array_values(array_filter($items, fn($it) => ($it['id'] ?? '') !== $id));
  write_json('items.json', $items);
  flash_set('Položka smazána.', 'success');
  redirect('index.php?page=items&collection=' . urlencode($cid));
}

// ---------- Render ----------
$stats = collection_stats($collections, $items);

$flash = flash_get();

include __DIR__ . '/pages/_layout.php';
