(function(){
  const qs = (s, el=document)=> el.querySelector(s);
  const qsa = (s, el=document)=> Array.from(el.querySelectorAll(s));

  // Toast
  function toast(msg, type='ok'){
    let wrap = qs('#toast-wrap');
    if(!wrap){
      wrap = document.createElement('div');
      wrap.id = 'toast-wrap';
      wrap.style.position = 'fixed';
      wrap.style.inset = 'auto 14px 14px auto';
      wrap.style.display = 'grid';
      wrap.style.gap = '10px';
      wrap.style.zIndex = '9999';
      document.body.appendChild(wrap);
    }
    const t = document.createElement('div');
    t.className = 'toast toast-' + type;
    t.textContent = msg;
    wrap.appendChild(t);
    setTimeout(()=> t.classList.add('show'), 10);
    setTimeout(()=> { t.classList.remove('show'); setTimeout(()=> t.remove(), 300); }, 2800);
  }
  window.__toast = toast;

  // Modal (data-modal-open="#id")
  qsa('[data-modal-open]').forEach(btn => {
    btn.addEventListener('click', () => {
      const id = btn.getAttribute('data-modal-open');
      const m = qs(id);
      if(m){ m.classList.add('open'); document.body.classList.add('no-scroll'); }
    });
  });
  qsa('[data-modal-close]').forEach(btn => {
    btn.addEventListener('click', () => {
      const m = btn.closest('.modal');
      if(m){ m.classList.remove('open'); document.body.classList.remove('no-scroll'); }
    });
  });
  qsa('.modal').forEach(m => {
    m.addEventListener('click', (e)=> {
      if(e.target === m){ m.classList.remove('open'); document.body.classList.remove('no-scroll'); }
    });
  });

  // Tiny sparkline chart for valuation history
  qsa('[data-spark]').forEach((el) => {
    try{
      const points = JSON.parse(el.getAttribute('data-spark') || '[]');
      if(points.length < 2) return;
      const w = 160, h = 46, pad = 6;
      const c = document.createElement('canvas');
      c.width = w; c.height = h;
      el.appendChild(c);
      const ctx = c.getContext('2d');
      const min = Math.min(...points);
      const max = Math.max(...points);
      const xStep = (w - 2*pad) / (points.length - 1);
      const y = (v) => {
        if(max === min) return h/2;
        const t = (v - min)/(max - min);
        return (h - pad) - t*(h - 2*pad);
      };
      ctx.lineWidth = 2;
      ctx.strokeStyle = 'rgba(255,255,255,0.85)';
      ctx.beginPath();
      points.forEach((v, i)=>{
        const x = pad + i*xStep;
        const yy = y(v);
        if(i===0) ctx.moveTo(x, yy);
        else ctx.lineTo(x, yy);
      });
      ctx.stroke();
    }catch(e){/* ignore */}
  });

  // Confirm actions
  qsa('[data-confirm]').forEach((el)=>{
    el.addEventListener('click', (e)=>{
      const msg = el.getAttribute('data-confirm') || 'Opravdu?';
      if(!confirm(msg)) e.preventDefault();
    })
  });

  // Show flash message from server
  const flash = qs('meta[name="flash"]')?.getAttribute('content');
  if(flash) toast(flash);
})();
