# Collector Prototype (Namecheap-ready)

## Requirements
- Shared hosting with PHP 7.4+ (Namecheap cPanel hosting is OK)

## Deploy on Namecheap (cPanel)
1. Open **cPanel → File Manager**
2. Go to **public_html** (or your add-on domain folder)
3. Upload the ZIP and **Extract**
4. IMPORTANT: you should have `index.php` directly inside your web root.
   - If extraction creates `collector_prototype/`, move its contents one level up into `public_html`.
5. Set folder permissions (File Manager → right click → Permissions):
   - `data` → **755** or **775**
   - `uploads` → **755** or **775**
   If saving doesn’t work, temporarily try **775**, and if still not, **777** (only for prototype).
6. Test in browser: `https://yourdomain.tld/`

## Notes
- Data is stored in JSON files in `/data`.
- Uploaded photos go to `/uploads`.
- `.htaccess` blocks direct access to internal folders and disables directory listing.

## Troubleshooting
- If you see a "500" error after upload, your hosting may not allow some `.htaccess` directives.
  Try removing the `Header set ...` lines first.
- If you cannot create collections/items, it’s almost always folder permissions for `data/` or `uploads/`.

## Demo data
- Demo sbírky a položky jsou už předvyplněné v:
  - `/data/collections.json`
  - `/data/items.json`
- Některé položky jsou schválně bez fotky / bez odhadu, aby bylo vidět „Work panel“ na dashboardu.
- Placeholder obrázek je v `/assets/placeholder.svg` a pár položek ho používá jako náhled.

Tip: pokud chceš začít „na čisto“, smaž obsah `collections.json` a `items.json` (nebo je přepiš na `[]`).
