<?php
if (session_status() === PHP_SESSION_NONE) session_start();
$active = $active ?? 'dashboard';
$mode = $mode ?? 'all';
$collections = $collections ?? [];
$selected_collection = $selected_collection ?? null;

function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }

function icon_for_type($type){
  $map = [
    'stamps' => 'Stamp',
    'coins' => 'Coin',
    'banknotes' => 'Banknote',
    'tcg' => 'Card',
    'crypto' => 'Crypto',
    'mixed' => 'Collection'
  ];
  return $map[$type] ?? 'Collection';
}
?>
<!doctype html>
<html lang="cs">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title><?= h($title ?? 'Collector Prototype') ?></title>
  <link rel="stylesheet" href="assets/style.css" />
</head>
<body>
<div class="layout">
  <aside class="sidebar">
    <div class="brand">
      <div class="logo">C</div>
      <div>
        <div style="font-weight:800">Collector</div>
        <div style="color:var(--muted); font-size:12px">oddělené sbírky</div>
      </div>
    </div>

    <nav class="nav">
      <a class="nav-item <?= $active==='dashboard'?'active':'' ?>" href="index.php?page=dashboard">Přehled</a>
      <a class="nav-item <?= $active==='collections'?'active':'' ?>" href="index.php?page=collections">Sbírky</a>
      <a class="nav-item <?= $active==='market'?'active':'' ?>" href="index.php?page=market">Trh / Ceny</a>
      <a class="nav-item <?= $active==='sell'?'active':'' ?>" href="index.php?page=sell">Prodej & Duplicity</a>
      <a class="nav-item <?= $active==='wishlist'?'active':'' ?>" href="index.php?page=wishlist">Wishlist</a>
      <a class="nav-item <?= $active==='stats'?'active':'' ?>" href="index.php?page=stats">Statistiky</a>
      <a class="nav-item <?= $active==='settings'?'active':'' ?>" href="index.php?page=settings">Nastavení</a>
    </nav>

    <div class="sidebar-footer">
      <div class="chip">TIP: Na mobilu uvidíš spodní lištu</div>
    </div>
  </aside>

  <main class="main">
    <header class="topbar">
      <div class="topbar-left">
        <div class="switcher">
          <form method="get" action="index.php" class="switcher-form">
            <input type="hidden" name="page" value="<?= h($_GET['page'] ?? 'dashboard') ?>" />
            <select name="cid" onchange="this.form.submit()">
              <option value="" <?= empty($selected_collection)?'selected':'' ?>>Všechny sbírky</option>
              <?php foreach($collections as $c): ?>
                <option value="<?= h($c['id']) ?>" <?= ($selected_collection && $selected_collection['id']===$c['id'])?'selected':'' ?>><?= h($c['name']) ?> (<?= h(strtoupper($c['currency'])) ?>)</option>
              <?php endforeach; ?>
            </select>
          </form>
        </div>
      </div>

      <div class="topbar-right">
        <form method="get" action="index.php" class="search">
          <input type="hidden" name="page" value="search" />
          <?php if(!empty($selected_collection)): ?>
            <input type="hidden" name="cid" value="<?= h($selected_collection['id']) ?>" />
          <?php endif; ?>
          <input name="q" placeholder="Hledat položky, tagy, roky..." value="<?= h($_GET['q'] ?? '') ?>" />
        </form>

        <div class="actions">
          <button class="btn" data-open="quickAdd">+ Přidat</button>
        </div>
      </div>
    </header>

    <!-- Quick add modal -->
    <div class="modal" id="modal-quickAdd" aria-hidden="true">
      <div class="modal-backdrop" data-close></div>
      <div class="modal-card">
        <div class="modal-header">
          <div style="font-weight:800">Rychle přidat</div>
          <button class="icon-btn" data-close title="Zavřít">✕</button>
        </div>
        <form method="post" action="index.php?page=actions" class="modal-body">
          <input type="hidden" name="action" value="add_item" />
          <label class="field">
            <span>Sbírka</span>
            <select name="collection_id" required>
              <?php foreach($collections as $c): ?>
                <option value="<?= h($c['id']) ?>" <?= ($selected_collection && $selected_collection['id']===$c['id'])?'selected':'' ?>><?= h($c['name']) ?></option>
              <?php endforeach; ?>
            </select>
          </label>
          <label class="field">
            <span>Název položky</span>
            <input name="title" required placeholder="např. 10 Kč 1933, Charizard #4..." />
          </label>
          <div class="grid2">
            <label class="field">
              <span>Rok (volitelně)</span>
              <input name="year" inputmode="numeric" placeholder="1999" />
            </label>
            <label class="field">
              <span>Množství</span>
              <input name="qty" inputmode="numeric" value="1" />
            </label>
          </div>
          <label class="field">
            <span>Odhad hodnoty (volitelně)</span>
            <input name="est_value" inputmode="numeric" placeholder="15000" />
          </label>
          <label class="field">
            <span>Tagy (odděl čárkou)</span>
            <input name="tags" placeholder="rare,favorite" />
          </label>
          <div class="modal-footer">
            <button class="btn btn-ghost" type="button" data-close>Zrušit</button>
            <button class="btn btn-primary" type="submit">Uložit</button>
          </div>
        </form>
      </div>
    </div>

    <div class="content">
