<?php
$active = 'stats';
$mode = $selected_collection ? 'single' : 'all';
$statsByCollection = collection_stats($collections, $items);
include __DIR__ . '/../partials/header.php';
?>
<section class="section">
  <div class="section-header">
    <div>
      <h1>Statistiky</h1>
      <p class="muted">Agregované statistiky + rozpad podle sbírek. (Výpočty jsou z lokálního JSON.)</p>
    </div>
  </div>

  <div class="grid2">
    <div class="card">
      <h3>Hodnota podle sbírek</h3>
      <canvas id="chartCollections" height="140"></canvas>
      <p class="muted small">Tip: kliknutím na sbírku v Přehledu přepneš kontext.</p>
    </div>

    <div class="card">
      <h3>Kvalita dat</h3>
      <div class="table-wrap">
        <table class="table">
          <thead>
            <tr>
              <th>Sbírka</th>
              <th>Položky</th>
              <th>Bez fotky</th>
              <th>Bez ocenění</th>
            </tr>
          </thead>
          <tbody>
            <?php foreach ($collections as $c):
              $st = $statsByCollection[$c['id']] ?? ['items'=>0,'missing_photo'=>0,'missing_value'=>0];
            ?>
              <tr>
                <td><a class="link" href="?page=collection&collection=<?=h($c['id'])?>"><?=h($c['name'])?></a></td>
                <td><?= (int)$st['items'] ?></td>
                <td><?= (int)$st['missing_photo'] ?></td>
                <td><?= (int)$st['missing_value'] ?></td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</section>

<script>
  window.__collectionsChart = {
    labels: <?= json_encode(array_map(fn($c)=>$c['name'], $collections), JSON_UNESCAPED_UNICODE) ?>,
    values: <?= json_encode(array_map(function($c) use ($statsByCollection){ return (float)(($statsByCollection[$c['id']]['value'] ?? 0)); }, $collections)) ?>
  };
</script>

<?php include __DIR__ . '/../partials/footer.php'; ?>
