<?php
$active = 'dashboard';
$mode = $selected_collection ? 'single' : 'all';
$statsByCollection = collection_stats($collections, $items);

$totalItems = 0;
$totalValue = 0;
$missingPhoto = 0;
$missingValue = 0;

foreach ($statsByCollection as $cid => $st) {
  $totalItems += $st['items'];
  $totalValue += $st['value'];
  $missingPhoto += $st['missing_photo'];
  $missingValue += $st['missing_value'];
}

include __DIR__ . '/../partials/header.php';
?>

<div class="hero">
  <div>
    <div class="title">Dashboard</div>
    <div class="sub">Rychlý přehled napříč sbírkami + úkoly na doplnění dat.</div>
  </div>
  <div class="hero-actions">
    <a class="btn primary" href="?page=collections">Správa sbírek</a>
    <button class="btn" data-open-modal="#modal-add-quick">Přidat položku</button>
  </div>
</div>

<div class="kpis">
  <div class="kpi">
    <div class="kpi-label">Celková hodnota (odhad)</div>
    <div class="kpi-value"><?= money_fmt($totalValue, 'CZK') ?></div>
    <div class="kpi-sub muted">Součet posledních ocenění položek</div>
  </div>
  <div class="kpi">
    <div class="kpi-label">Počet položek</div>
    <div class="kpi-value"><?= (int)$totalItems ?></div>
    <div class="kpi-sub muted">Včetně množství (qty)</div>
  </div>
  <div class="kpi">
    <div class="kpi-label">Bez fotky</div>
    <div class="kpi-value"><?= (int)$missingPhoto ?></div>
    <div class="kpi-sub"><a class="link" href="?page=items&filter=missing_photo">Otevřít seznam</a></div>
  </div>
  <div class="kpi">
    <div class="kpi-label">Bez ocenění</div>
    <div class="kpi-value"><?= (int)$missingValue ?></div>
    <div class="kpi-sub"><a class="link" href="?page=items&filter=missing_value">Otevřít seznam</a></div>
  </div>
  <div class="kpi">
    <div class="kpi-label">Krypto (demo)</div>
    <div class="kpi-value"><?= money_fmt($demoCryptoValue ?? 0, 'CZK') ?></div>
    <div class="kpi-sub muted">Simulace, bez API</div>
  </div>
</div>

<div class="grid2">
  <div class="card">
    <div class="card-head">
      <div>
        <div class="card-title">Hodnota podle sbírek</div>
        <div class="muted">Klikni na sbírku pro detail.</div>
      </div>
      <div class="pill">Agregace</div>
    </div>
    <div class="bars" data-bars>
      <?php foreach ($collections as $c):
        $st = $statsByCollection[$c['id']] ?? ['value'=>0,'items'=>0];
      ?>
        <a class="bar" href="?page=collection&collection=<?= h($c['id']) ?>">
          <div class="bar-top">
            <div class="bar-name"><?= h($c['name']) ?></div>
            <div class="bar-val"><?= money_fmt($st['value'], $c['currency'] ?? 'CZK') ?></div>
          </div>
          <div class="bar-track"><div class="bar-fill" data-value="<?= (float)$st['value'] ?>" data-total="<?= (float)max(1,$totalValue) ?>"></div></div>
          <div class="bar-sub muted"><?= type_label($c['type'] ?? '') ?> • <?= (int)$st['items'] ?> ks</div>
        </a>
      <?php endforeach; ?>
    </div>
  </div>

  <div class="card">
    <div class="card-head">
      <div>
        <div class="card-title">Top položky (napříč)</div>
        <div class="muted">Řazeno dle odhadované hodnoty.</div>
      </div>
      <a class="btn small" href="?page=items">Zobrazit vše</a>
    </div>

    <?php
      $sorted = $items;
      usort($sorted, fn($a,$b)=> (float)($b['est_value'] ?? 0) <=> (float)($a['est_value'] ?? 0));
      $top = array_slice($sorted, 0, 8);
    ?>

    <div class="table">
      <div class="trow thead">
        <div>Položka</div>
        <div>Sbírka</div>
        <div class="right">Odhad</div>
      </div>
      <?php foreach ($top as $it):
        $c = find_by_id($collections, $it['collection_id']);
      ?>
        <a class="trow" href="?page=item&id=<?= h($it['id']) ?>">
          <div>
            <div class="tmain"><?= h($it['title']) ?></div>
            <div class="muted small"><?= h(($it['year'] ?? '—')) ?> • <?= h(($it['grade'] ?? '—')) ?></div>
          </div>
          <div class="muted"><?= h($c['name'] ?? '—') ?></div>
          <div class="right"><strong><?= money_fmt($it['est_value'] ?? null, $c['currency'] ?? 'CZK') ?></strong></div>
        </a>
      <?php endforeach; ?>
    </div>
  </div>
</div>

<!-- Quick add modal -->
<div class="modal" id="modal-add-quick">
  <div class="modal-card">
    <div class="modal-head">
      <div>
        <div class="card-title">Rychle přidat položku</div>
        <div class="muted">Základní info teď, detaily později.</div>
      </div>
      <button class="iconbtn" data-close-modal>✕</button>
    </div>
    <form method="post" action="?action=create_item">
      <div class="form-grid">
        <label>
          <div class="label">Sbírka</div>
          <select name="collection_id" required>
            <?php foreach ($collections as $c): ?>
              <option value="<?= h($c['id']) ?>"><?= h($c['name']) ?> (<?= type_label($c['type']) ?>)</option>
            <?php endforeach; ?>
          </select>
        </label>
        <label>
          <div class="label">Název</div>
          <input name="title" required placeholder="např. 10 Kč 1933 / Charizard #4" />
        </label>
        <label>
          <div class="label">Qty</div>
          <input type="number" name="qty" value="1" min="1" />
        </label>
        <label>
          <div class="label">Odhad (CZK)</div>
          <input type="number" name="est_value" placeholder="např. 1500" />
        </label>
        <label>
          <div class="label">Rok</div>
          <input type="number" name="year" placeholder="např. 1999" />
        </label>
        <label>
          <div class="label">Tagy (čárky)</div>
          <input name="tags" placeholder="rare, favorite" />
        </label>
      </div>
      <div class="modal-actions">
        <button class="btn" type="button" data-close-modal>Zrušit</button>
        <button class="btn primary" type="submit">Uložit</button>
      </div>
    </form>
  </div>
</div>

<?php include __DIR__ . '/../partials/footer.php'; ?>
