<?php
$active = 'collections';
$mode = 'single';
if (!$selected_collection) {
  flash_set('Sbírka nenalezena.', 'error');
  redirect('?page=collections');
}

$cid = $selected_collection['id'];
$statsByCollection = collection_stats($collections, $items);
$st = $statsByCollection[$cid] ?? ['items'=>0,'value'=>0,'missing_photo'=>0,'missing_value'=>0,'currency'=>$selected_collection['currency'] ?? 'CZK'];

$itemsInCollection = array_values(array_filter($items, fn($x) => ($x['collection_id'] ?? '') === $cid));

// simple breakdown by year bucket
$byYear = [];
foreach ($itemsInCollection as $it) {
  $y = (int)($it['year'] ?? 0);
  $key = $y ? (string)$y : '—';
  $byYear[$key] = ($byYear[$key] ?? 0) + 1;
}
ksort($byYear);

include __DIR__ . '/../partials/header.php';
?>

<section class="section">
  <div class="section-header">
    <div>
      <h1><?php echo h($selected_collection['name']); ?></h1>
      <p class="muted"><?php echo type_label($selected_collection['type']); ?> • Měna: <?php echo h($selected_collection['currency'] ?? 'CZK'); ?> • Vytvořeno: <?php echo h($selected_collection['created_at'] ?? ''); ?></p>
    </div>
    <div class="row gap">
      <a class="btn" href="?page=items&collection=<?php echo h($cid); ?>">Položky</a>
      <button class="btn primary" data-open-modal="#modalAddItem">+ Přidat položku</button>
    </div>
  </div>

  <div class="kpi">
    <div class="card">
      <div class="muted">Hodnota sbírky</div>
      <div class="kpi-value"><?php echo money_fmt($st['value'], $st['currency']); ?></div>
      <div class="kpi-sub">Poslední odhad: dnes (prototype)</div>
    </div>
    <div class="card">
      <div class="muted">Počet položek</div>
      <div class="kpi-value"><?php echo (int)$st['items']; ?></div>
      <div class="kpi-sub">Součet qty</div>
    </div>
    <a class="card link" href="?page=items&collection=<?php echo h($cid); ?>&filter=missing_photo">
      <div class="muted">Bez fotky</div>
      <div class="kpi-value"><?php echo (int)$st['missing_photo']; ?></div>
      <div class="kpi-sub">Klikni pro seznam</div>
    </a>
    <a class="card link" href="?page=items&collection=<?php echo h($cid); ?>&filter=missing_value">
      <div class="muted">Bez ocenění</div>
      <div class="kpi-value"><?php echo (int)$st['missing_value']; ?></div>
      <div class="kpi-sub">Klikni pro seznam</div>
    </a>
  </div>

  <div class="grid2">
    <div class="card">
      <div class="card-title">Struktura (podle roku)</div>
      <div class="chart" data-chart="bars" data-label="Rok" data-series='<?php echo h(json_encode($byYear)); ?>'></div>
      <div class="muted" style="margin-top:10px">Tip: pro TCG můžeš přepnout na edice/rarity, pro mince na materiál/mint.</div>
    </div>

    <div class="card">
      <div class="card-title">Nejhodnotnější položky</div>
      <?php
        usort($itemsInCollection, fn($a,$b) => (float)($b['est_value'] ?? 0) <=> (float)($a['est_value'] ?? 0));
        $top = array_slice($itemsInCollection, 0, 5);
      ?>
      <div class="table">
        <div class="tr head">
          <div>Položka</div>
          <div class="right">Odhad</div>
        </div>
        <?php if (!$top): ?>
          <div class="empty">Zatím žádné položky. Přidej první.</div>
        <?php endif; ?>
        <?php foreach ($top as $it): ?>
          <a class="tr" href="?page=item&collection=<?php echo h($cid); ?>&id=<?php echo h($it['id']); ?>">
            <div>
              <div class="strong"><?php echo h($it['title']); ?></div>
              <div class="muted small"><?php echo h($it['location'] ?? ''); ?></div>
            </div>
            <div class="right"><?php echo money_fmt($it['est_value'] ?? null, $selected_collection['currency']); ?></div>
          </a>
        <?php endforeach; ?>
      </div>
    </div>
  </div>
</section>

<!-- Add item modal (collection scoped) -->
<div class="modal" id="modalAddItem" aria-hidden="true">
  <div class="modal-card">
    <div class="modal-head">
      <div>
        <div class="modal-title">Přidat položku</div>
        <div class="muted">Do sbírky: <span class="strong"><?php echo h($selected_collection['name']); ?></span></div>
      </div>
      <button class="icon-btn" data-close-modal aria-label="Zavřít">×</button>
    </div>
    <form method="post" action="?action=create_item&collection=<?php echo h($cid); ?>" class="form">
      <div class="form-grid">
        <label>
          <div class="label">Název</div>
          <input name="title" required placeholder="např. 10 Kč 1932, Charizard #4, ..." />
        </label>
        <label>
          <div class="label">Množství</div>
          <input type="number" name="qty" value="1" min="1" />
        </label>
        <label>
          <div class="label">Lokace</div>
          <input name="location" placeholder="Album 1 / Strana 3" />
        </label>
        <label>
          <div class="label">Odhad hodnoty (<?php echo h($selected_collection['currency']); ?>)</div>
          <input type="number" name="est_value" placeholder="např. 1500" />
        </label>
        <label>
          <div class="label">Rok</div>
          <input type="number" name="year" placeholder="např. 1999" />
        </label>
        <label>
          <div class="label">Tagy (čárky)</div>
          <input name="tags" placeholder="rare, favorite" />
        </label>
        <label class="full">
          <div class="label">Poznámka</div>
          <textarea name="notes" placeholder="stav, varianta, grading, ..."></textarea>
        </label>
      </div>
      <div class="modal-actions">
        <button class="btn" type="button" data-close-modal>Zrušit</button>
        <button class="btn primary" type="submit">Uložit</button>
      </div>
    </form>
  </div>
</div>

<?php include __DIR__ . '/../partials/footer.php'; ?>
